
B_767_200 =  {

	Name 		= 'B_767_200', --AG
	DisplayName	= _('B-767-200'), --AG
	Picture 	= "B-767-200.png",
	Rate 		= "40", -- RewardPoint in Multiplayer
	Shape		= "B_767_200", --AG
	WorldID		=  WSTYPE_PLACEHOLDER,
	singleInFlight 	= true,

	shape_table_data 	= 
	{
		{
			file  	 	= 'B_767_200'; --AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'kc-135-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 		-- Fire on the ground after destoyed: 300sec 2m
			username	= 'B_767_200'; --AG
			index    	=  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning 	= "BYNORMAL";
		},
		{
			name  		= "kc-135-oblomok";
			file  		= "kc-135-oblomok";
			fire  		= { 240, 2};
		},
	},

		mapclasskey 		= "P0091000029",
		attribute  		= {
			wsType_Air, wsType_Airplane, wsType_Cruiser, WSTYPE_PLACEHOLDER,
			"Transports",},

		Categories = {
		},

		M_empty		=	80100 + 2800,		-- kg , + 40x passengers
		M_nominal	=	125000,		-- kg
		M_max		=	142900,		-- kg
		M_fuel_max	=	60000,		-- kg
		H_max		=	13100,		-- max altitude/ceiling (meters)
		average_fuel_consumption	=	0.13,
		CAS_min		=	120,
		V_opt		=	232,		-- m/s
		V_take_off	=	85,		-- m/s
		V_land		=	72,		-- m/s
		has_afteburner	=	false,
		has_speedbrake	=	true,
		has_thrustReverser	=	true,
		has_differential_stabilizer = false,

		main_gear_pos 	= 	{0.090,	-4.040,	4.66},
		main_gear_wheel_diameter	=	1.16,
		main_gear_amortizer_direct_stroke        = 0.42,	-- down from main_gear_pos (plus)
		main_gear_amortizer_reversal_stroke      = -0.14,	-- up (minus)
		main_gear_amortizer_normal_weight_stroke = 0.00,	-- down from main_gear_pos with weight

		nose_gear_pos 	= 	{19.78,	-4.040,	0},
		nose_gear_wheel_diameter	=	0.93,
		nose_gear_amortizer_direct_stroke        = 0.12,	-- down from nose_gear_pos (plus)
		nose_gear_amortizer_reversal_stroke      = -0.09,	-- up (minus)
		nose_gear_amortizer_normal_weight_stroke = 0.06,	-- down from nose_gear_pos with weight

		radar_can_see_ground	=	true,
		AOA_take_off	=	0.14,
		stores_number	=	0,
		bank_angle_max	=	45,
		Ny_min	=	0.5,
		Ny_max	=	2.5,
		tand_gear_max	=	3.73,
		V_max_sea_level	=	200,
		V_max_h	=	280.28,
		tanker_type	=	0,
		wing_area	=	283,
		wing_span	=	47.57, 
		thrust_sum_max	=	48000,  -- reduced from 50000,
		thrust_sum_ab	=	48000,  -- reduced from 50000,
		Vy_max	=	10,
		length		=	48.51,
		height		=	15.9,
		flaps_maneuver	=	0.5,
		Mach_max	=	0.9,
		range		=	7200,
		crew_size	=	2,
		RCS	=	80,
		Ny_max_e	=	2,
		detection_range_max	=	0,
		IR_emission_coeff	=	4,
		IR_emission_coeff_ab	=	0,
		engines_count	=	2,
		wing_tip_pos 	= 	{-7.3, 1.45,	23.78},
		engines_nozzles = 
		{
		{
			pos = 	{2.60,	-1.955,	7.9},
			elevation	=	0,
			diameter	=	1.1,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level 	= 	0.03, 
		}, 	
		{
			pos = 	{2.60,	-1.955,	-7.9},
			elevation	=	0,
			diameter	=	1.1,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level 	= 	0.03, 
		}, 
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{7.916,	0.986,	0},
			}, -- end of [1]
			[2] = 
			{
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{3.949,	1.01,	0},
			}, -- end of [2]
		}, -- end of crew_members
		brakeshute_name	=	0,
		is_tanker	=	false,
--		air_refuel_receptacle_pos = 	{6.731,	0.825,	0.492},
		fires_pos = 
		{
			[1] = 	{3.25,	-2.19,	0},
			[2] = 	{2.33,	-0.85,	6.0},
			[3] = 	{2.33,	-0.85,	-6.0},
			[4] = 	{3.87,	-1.23,	3.77},
			[5] = 	{3.87,	-1.23,	-3.77},
			[6] = 	{5.5,	-3.4,	7.9},
			[7] = 	{5.5,	-3.4,	-7.9},
			[8] = 	{-0.8,	0.0,	11.6},
			[9] = 	{-0.8,	0.0,	-11.6},
			[10] = 	{-2.9,	0.46,	15.8},
			[11] = 	{-2.9,	0.46,	-15.8},
		}, -- end of fires_pos

		CanopyGeometry = {
			azimuth = {-110.0, 110.0},
			elevation = {-40.0, 70.0}
		},

	Failures = {
		{ id = 'asc', 		label = _('ASC'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'autopilot', 	label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'l_engine',  	label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'r_engine',	label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Pylons = {
	},

	Tasks = {
		aircraft_task(Transport),
	},
	DefaultTask = aircraft_task(Nothing),

	SFM_Data = {     --kc-135
	aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.015,
			cx_flap	=	0.05,
			cy_flap	=	1,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.023,	0.117,	0.064,	0,	0.5,	20,	1.4},
				[2] = 	{0.2,	0.023,	0.117,	0.064,	0,	1.5,	20,	1.4},
				[3] = 	{0.4,	0.023,	0.117,	0.064,	0,	2.5,	20,	1.4},
				[4] = 	{0.6,	0.025,	0.117,	0.064,	0.022,	3.5,	20,	1.4},
				[5] = 	{0.7,	0.03,	0.117,	0.083,	0.031,	3.5,	20,	1.2},
				[6] = 	{0.8,	0.032,	0.117,	0.107,	0.04,	3.5,	20,	1},
				[7] = 	{0.9,	0.045,	0.117,	0.148,	0.058,	3.5,	20,	0.8},
				[8] = 	{1,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.7},
				[9] = 	{1.5,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.2},
			}, -- end of table_data
		}, -- end of aerodynamics
	engine = 
		{
			Nmg	=	65.9,	-- RPM at idle
			MinRUD	=	0,	-- Min state of the throttle
			MaxRUD	=	1,	-- Max state of the throttle
			MaksRUD	=	1,	-- Military power state of the throttle
			ForsRUD	=	1,	-- Afterburner state of the throttle
			typeng	=	4,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN    = 4
				E_TURBOSHAFT = 5
			--]]
			hMaxEng	=	14.8,	-- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085,	-- Engine drag coeficient
								-- Affects drag of engine when shutdown
								-- cemax/cefor affect sponginess of elevator/inertia at slow speed
								-- affects available g load apparently
			cemax	=	1.24,	-- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in );  fuel consumption for a single engine in dry configuration. Units are in kg / sec.
			cefor	=	2.56,	-- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in );  fuel consumption for a single engine in afterburner configuration. Units are in kg / sec.
			dpdh_m	=	9000,	--  altitude coefficient for max thrust
			dpdh_f	=	9000,	--  altitude coefficient for AB thrust
			table_data = 
			{	-- kc-135 * 1.38 * 0.96
					--   M      Pmax		Pmax_ab
				[1] = 	{0.0,	494945,		494945},
				[2] = 	{0.2,	414340,		414340},
				[3] = 	{0.4,	369620,		369620},
				[4] = 	{0.6,	332525,		332525},
				[5] = 	{0.7,	335175,		335175},
				[6] = 	{0.8,	347098,		347098},
				[7] = 	{0.9,	362995,		362995},
				[8] = 	{1.0,	369620,		369620},
				[9] = 	{1.1,	370944,		370944},
				[10] = 	{1.2,	352397,		352397},
				[11] = 	{1.3,	125856,		125856},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},

	DamageParts = 
	{  
--		[1] = "kc-135-oblomok-wing-r", -- wing R
--		[2] = "kc-135-oblomok-wing-l", -- wing L
--		[3] = "kc-135-oblomok-noise", -- nose
--		[4] = "kc-135-oblomok-tail-r", -- tail
--		[5] = "kc-135-oblomok-tail-l", -- tail
	},


-- DCS World\Scripts\Aircrafts\_Common\Lights.lua

	lights_data = { typename = "collection", lights = {

		[WOLALIGHT_STROBES] = { typename = "collection",
			lights = {
				{typename  = "natostrobelight", connector =  "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.0,},
				{typename  = "natostrobelight", connector =  "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.5,},
				{
					typename = "Spot", connector = "WHITE_BEACON_L",
					controller = "VariablePatternStrobe", mode = "2 Flash Long",
					proto = lamp_prototypes.MPS_1, intensity_max = 400.0, period = 0.333, phase_shift = 0.25,
					direction = {azimuth = math.rad(-90.0), elevation = math.rad(0)}, angle_max = math.rad(180.0), angle_min = math.rad(0),
				},
				{
					typename = "Spot", connector = "WHITE_BEACON_R",
					controller = "VariablePatternStrobe", mode = "2 Flash Long",
					proto = lamp_prototypes.MPS_1, intensity_max = 400.0, period = 0.333, phase_shift = 0.25,
					direction = {azimuth = math.rad(90.0), elevation = math.rad(0)}, angle_max = math.rad(180.0), angle_min = math.rad(0),
				},
			}
		},
		[WOLALIGHT_BEACONS] = { typename = "collection",
			lights = {
				{typename  = "natostrobelight", connector = "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.0,},
				{typename  = "natostrobelight", connector = "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.5,},
			}
		},
		[WOLALIGHT_NAVLIGHTS] = { typename = "collection",
			lights = {
				{
					typename = "Spot", connector = "BANO_0", dir_correction = {azimuth = math.rad(180.0)}, argument = 192,
					proto = lamp_prototypes.HS_2A, angle_max = math.rad(180.0), angle_min = math.rad(170.0),
				},
				{
					typename = "Spot", connector = "BANO_00", dir_correction = {azimuth = math.rad(180.0)}, argument = 192,
					proto = lamp_prototypes.HS_2A, angle_max = math.rad(180.0), angle_min = math.rad(170.0),
				},
				{
					typename = "Spot", connector = "BANO_1", dir_correction = {azimuth = math.rad(-45.0), elevation = math.rad(45.0)}, argument = 190,
					proto = lamp_prototypes.BANO_7M_red,
				},
				{
					typename = "Spot", connector = "BANO_2", dir_correction = {azimuth = math.rad(45.0), elevation = math.rad(45.0)}, argument = 191,
					proto = lamp_prototypes.BANO_7M_green,
				},
				{typename = "argumentlight", argument = 68,},		-- Logo Lights ON
			}
		},
		[WOLALIGHT_FORMATION_LIGHTS] = { typename = "collection", -- Nav Lights always ON in flights gimick
			lights = {
				{typename = "argumentlight", argument = 192,},
				{typename = "argumentlight", argument = 190,},
				{typename = "argumentlight", argument = 191,},
				{typename  = "natostrobelight", connector =  "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.0,},
				{typename  = "natostrobelight", connector =  "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.SMI_2KM, period = 1.9, phase_shift = 0.5,},
			}
		},
		[WOLALIGHT_SPOTS] = { typename = "collection",
			lights = {
				{
					typename = "Spot", connector = "RESERV2_SPOT_PTR", argument = 208, dir_correction = {azimuth = math.rad(4.0), elevation = math.rad(3.0)},
					proto = lamp_prototypes.LFS_P_27_600,
				},
				{
					typename = "Omni", connector = "RESERV2_SPOT_PTR", pos_correction = {0.3, 0.0, 0.08},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
				},
				{
					typename = "Spot", connector = "RESERV1_SPOT_PTR", argument = 208, dir_correction = {azimuth = math.rad(-4.0), elevation = math.rad(3.0)},
					proto = lamp_prototypes.LFS_P_27_600,
				},
				{
					typename = "Omni", connector = "RESERV1_SPOT_PTR", pos_correction = {0.3, 0.0, -0.08},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
				},
				{
					typename = "Spot", connector = "MAIN1_SPOT_PTR", argument = 208, dir_correction = {azimuth = math.rad(-1.0), elevation = math.rad(2.5)},
					proto = lamp_prototypes.LFS_P_27_600, movable = true,
				},
				{
					typename = "Omni", connector = "MAIN1_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0, movable = true,
				},
				{
					typename = "Spot", connector = "MAIN2_SPOT_PTR", argument = 208, dir_correction = {azimuth = math.rad(1.0), elevation = math.rad(2.5)},
					proto = lamp_prototypes.LFS_P_27_600, movable = true,
				},
				{
					typename = "Omni", connector = "MAIN2_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0, movable = true,
				},
			}
		},
		[WOLALIGHT_TAXI_LIGHTS] = { typename = "collection",
			lights = {
				{
					typename = "spotlight", connector = "MAIN3_SPOT_PTR", argument = 209, dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(1.0)},
					proto = lamp_prototypes.LFS_R_27_250, movable = true,
				},
				{
					typename = "omnilight", connector = "MAIN3_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_R_27_250, range = 6.0, movable = true,
				},
				{
					typename = "Spot", connector = "RESERV3_SPOT_PTR", argument = 209, 
					proto = lamp_prototypes.LFS_R_27_250,
				},
				{
					typename = "Omni", connector = "RESERV3_SPOT_PTR", pos_correction = {0.2, 0.0, 0.2},
					proto = lamp_prototypes.LFS_R_27_250, range = 6.0,
				},
				{
					typename = "Spot", connector = "RESERV4_SPOT_PTR", argument = 209, 
					proto = lamp_prototypes.LFS_R_27_250,
				},
				{
					typename = "Omni", connector = "RESERV4_SPOT_PTR", pos_correction = {0.2, 0.0, -0.2},
					proto = lamp_prototypes.LFS_R_27_250, range = 6.0,
				},
			}
		},
		[WOLALIGHT_CABIN_NIGHT] = { typename = "collection",
			lights = {
				{ typename = "argumentlight", argument = 69, },
			}
		},
	}},

}

add_aircraft(B_767_200)
